/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_918;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.Widget;

public class TabsWidget
extends Widget {
    private static final class_2960 creativeInventoryTabs = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    private final ElementScreen[] tabActive = new ElementScreen[3];
    private final ElementScreen[] tab = new ElementScreen[3];
    public class_2960 tabsResource = creativeInventoryTabs;
    public int yOffset = 4;
    public int spacing = 2;
    public int selected;
    public int highlighted;
    protected List<class_1799> icons = Lists.newArrayList();
    private final MultiModuleScreen<?> parent;
    private boolean clicked = false;
    private boolean leftMouseDown = false;

    public TabsWidget(MultiModuleScreen<?> parent, ElementScreen tabLeft, ElementScreen tabCenter, ElementScreen tabRight, ElementScreen activeLeft, ElementScreen activeCenter, ElementScreen activeRight) {
        this.parent = parent;
        this.tab[0] = tabLeft;
        this.tab[1] = tabCenter;
        this.tab[2] = tabRight;
        this.tabActive[0] = activeLeft;
        this.tabActive[1] = activeCenter;
        this.tabActive[2] = activeRight;
        this.selected = 0;
    }

    public void addTab(class_1799 icon) {
        this.icons.add(icon);
    }

    public void clear() {
        this.selected = 0;
        this.icons.clear();
    }

    @Override
    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.leftMouseDown = true;
        }
    }

    @Override
    public void handleMouseReleased() {
        this.leftMouseDown = false;
    }

    public void update(int mouseX, int mouseY) {
        mouseX -= this.xPos;
        this.highlighted = -1;
        if ((mouseY -= this.yPos) >= 0 && mouseY <= this.tab[1].h) {
            int x = 0;
            for (int i = 0; i < this.icons.size(); ++i) {
                if (mouseX >= x && mouseX < x + this.tab[1].w) {
                    this.highlighted = i;
                    break;
                }
                x += this.tab[1].w;
                x += this.spacing;
            }
        }
        if (this.clicked) {
            if (!this.leftMouseDown) {
                this.clicked = false;
            }
            return;
        }
        if (!this.leftMouseDown) {
            return;
        }
        this.clicked = true;
        if (this.highlighted > -1) {
            this.selected = this.highlighted;
        }
    }

    @Override
    public void draw(class_332 guiGraphics, class_2960 texture) {
        int y = this.yPos + this.yOffset;
        for (int i = 0; i < this.icons.size(); ++i) {
            int x = this.xPos + i * this.tab[0].w;
            if (i > 0) {
                x += i * this.spacing;
            }
            ElementScreen[] toDraw = i == this.selected ? this.tabActive : this.tab;
            ElementScreen actualTab = i == 0 && x == this.parent.cornerX ? toDraw[0] : (x == this.parent.cornerX + this.parent.field_22789 ? toDraw[2] : toDraw[1]);
            actualTab.draw(guiGraphics, this.tabsResource, x, y);
            class_1799 icon = this.icons.get(i);
            if (icon == null) continue;
            this.drawItemStack(guiGraphics, icon, x + (actualTab.w - 16) / 2, y + (actualTab.h - 16) / 2);
        }
    }

    private void drawItemStack(class_332 guiGraphics, class_1799 stack, int x, int y) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 232.0f);
        class_918 itemRender = class_310.method_1551().method_1480();
        guiGraphics.method_51427(stack, x, y);
        guiGraphics.method_51448().method_22909();
    }
}

